﻿namespace BankPosPay.ViewModel
{


    public class SadadPosTransaction
    {
        public int Protocol { get; set; }
        /// <summary>
        /// نوع تراکنش (مثلاً: Sale, BalanceInquiry, BillPayment, SpecialPayment)
        /// </summary>
        public int MsgTypecount { get; set; }

        /// <summary>
        /// شماره ترمینال
        /// </summary>
        public string TerminalID { get; set; }

        /// <summary>
        /// مبلغ به ریال
        /// </summary>
        public string Amount { get; set; }

        /// <summary>
        /// عنوان متنی برای درج بر روی رسید
        /// </summary>
        public string PrintStr { get; set; }

        /// <summary>
        /// شناسه قبض (در تراکنش‌های پرداخت قبض)
        /// یا شناسه پرداخت (در خریدهای شناسه‌دار)
        /// </summary>
        public string BillID { get; set; }

        /// <summary>
        /// شناسه خدمت (در تراکنش‌های پرداخت قبض خاص)
        /// </summary>
        public string PaymentID { get; set; }

        /// <summary>
        /// شناسه خدمت در تراکنش‌های پرداخت خاص
        /// </summary>
        public string SpServiceID { get; set; }

        /// <summary>
        /// نسخه جدول حساب‌های چندحسابی
        /// </summary>
        public bool MultiAccTableVer { get; set; }

        /// <summary>
        /// فعال‌سازی ارسال شماره سریال پایانه
        /// </summary>
        public bool POSSerialEnable { get; set; }

        /// <summary>
        /// شماره سریال پایانه
        /// </summary>
        public string POSSerialData { get; set; }

        /// <summary>
        /// نوع بانک (در صورت عدم تعیین، مطابق با برنامه پرداخت سپهر در نظر گرفته می‌شود)
        /// </summary>
        public int BankId { get; set; }
        public bool MultiAccEnable { get; set; }
        public string MultiAccData { get; set; }
        public string IPAddress { get; set; }
        public int IPPort { get; set; }
        public string PortNumber { get; set; }
        public int CancelTimeout { get; internal set; }
        public string OrderId { get; internal set; }
    }

   
}
        
