﻿using BankPosPay.ViewModel;
using Sadad.PcPos.Core;
using System;
using System.Collections.Generic;
namespace zoheirsoftwareData.Service.BankPos.Meli
{
    public class SadadPos
    {
        public string GetUnixTime()
        {
            return Convert.ToInt64(DateTime.UtcNow.Subtract(new DateTime(1970, 1, 1)).TotalMilliseconds).ToString();
        }

        public string SendRequset(SadadPosTransaction posTransaction)
        {
            PcPosBusiness PcPos = new PcPosBusiness();
           
            #region Clear PcPos Data
            PcPos.ClearAmount();
            PcPos.ClearBillInfo();
            PcPos.ClearCardInfo();
            PcPos.ClearMultiAccountData();
            PcPos.ClearMultiSaleId();
            PcPos.ClearOrderId();
            PcPos.ClearSaleId();
            #endregion
            #region Magic Transaction
            //var mData = new MagicData();
            //mData.RequestId = posTransaction.OrderId;
            //mData.Amount = posTransaction.Amount;
            //mData.TerminalId = posTransaction.TerminalID;
            //mData.MerchantId = posTransaction.POSSerialData;
            //mData.BillNo = posTransaction.BillID;

            //PcPos.MagicData = mData;
            //PcPos.DeviceType = DeviceType.Magic;

            #endregion


            var connectiontimout = 5000;

            PcPos.RetryTimeOut = new int[] { connectiontimout, connectiontimout, connectiontimout };

            if (posTransaction.TerminalID.Length < 8)
            {
                return "شماره پایانه نامعتبر است ";

            }
            else
            {
                if (!string.IsNullOrEmpty(posTransaction.OrderId))
                {
                    PcPos.SetSaleId(posTransaction.OrderId);
                }
                else
                {
                    PcPos.SetSaleId(GetUnixTime());
                }

                var ResponseTimeOut = 180000;
                PcPos.ResponseTimeOut = new int[] { ResponseTimeOut, connectiontimout, connectiontimout };
                PcPos.Amount = posTransaction.Amount;
                PcPos.SerialNo = posTransaction.POSSerialData;
                PcPos.SetAdvertisement(posTransaction.PrintStr);
                PcPos.SetThirdPartyAppCode(123);
                if (posTransaction.Protocol == 1)
                {
                    PcPos.Port = posTransaction.IPPort;

                    PcPos.ComPortName = "COM1";
                    PcPos.ConnectionType = PcPosConnectionType.Serial;

                }
                else
                {
                    PcPos.IP = posTransaction.IPAddress;
                    PcPos.Port = posTransaction.IPPort;
                    PcPos.ConnectionType = PcPosConnectionType.Lan;
                }


                var res = PcPos.SyncSaleTransaction();
                return (res.ResponseCodeMessage);

            }


        }


        public static readonly Dictionary<string, string> Messages = new Dictionary<string, string>()
        {
            ["00"] = "تراکنش موفق",
            ["0"] = "تراکنش موفق",
            ["03"] = "پذیرنده نامعتبر",
            ["05"] = "تراکنش رد شد",
            ["06"] = "خطا در شروع بکار",
            ["07"] = "شماره تأیید موجود نیست",
            ["12"] = "تراکنش مردود شد",
            ["13"] = "مبلغ اشتباه",
            ["14"] = "کارت ناشناخته",
            ["15"] = "قبلاً باز شده",
            ["16"] = "قبلاً بسته شده",
            ["19"] = "دوباره سعی کنید",
            ["20"] = "قبض مورد تأیید نیست",
            ["21"] = "محدودیت زمان کاری",
            ["24"] = "عملیات پایان روز",
            ["25"] = "سریال پایانه نامعتبر",
            ["29"] = "عملیات پایان روز",
            ["30"] = "فرمت اشتباه",
            ["31"] = "عدم پذیرش صادرکننده",
            ["32"] = "پایانه غیرفعال",
            ["33"] = "کارت منقضی",
            ["34"] = "تراکنش اصلی ناموفق",
            ["38"] = "رمز اشتباه بیش از حد",
            ["41"] = "کارت مفقودی",
            ["43"] = "کارت دزدی",
            ["44"] = "شارژ موجود نیست",
            ["47"] = "زمان منقضی شده",
            ["48"] = "قبلاً انجام شده یا موجودی ناکافی",
            ["54"] = "کارت منقضی",
            ["55"] = "رمز اشتباه",
            ["56"] = "کارت اشتباه",
            ["57"] = "عملیات نامعتبر",
            ["58"] = "عملیات نامعتبر",
            ["60"] = "لیست سیاه آماده نیست",
            ["61"] = "محدودیت مبلغ",
            ["62"] = "محدودیت مبلغ",
            ["63"] = "MAC اشتباه",
            ["64"] = "تراکنش اشتباه",
            ["65"] = "تعداد بیش از حد",
            ["66"] = "حساب مسدود",
            ["68"] = "موجودی اشتباه",
            ["70"] = "تراکنش اشتباه",
            ["71"] = "تراکنش اشتباه",
            ["75"] = "رمز اشتباه بیش از حد",
            ["77"] = "روز مالی اشتباه",
            ["78"] = "کارت فعال نیست",
            ["79"] = "حساب تعریف نشده",
            ["80"] = "تراکنش ناموفق",
            ["81"] = "کارت باطل شده",
            ["83"] = "مرکز آماده نیست",
            ["84"] = "مرکز آماده نیست",
            ["85"] = "خطای داخلی",
            ["86"] = "پایانه نامعتبر",
            ["87"] = "خطای رمز",
            ["88"] = "خطای داخلی",
            ["89"] = "خطای داخلی",
            ["90"] = "عملیات پایان روز",
            ["91"] = "صادرکننده غیر فعال",
            ["92"] = "بانک صادرکننده نامعتبر",
            ["93"] = "صف پر شده",
            ["94"] = "تراکنش تکراری",
            ["96"] = "خطای داخلی",
            ["97"] = "شروع بکار نشده"
        };


    }

}
