﻿using BankPosPay.ViewModel;
using System;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;
using zoheirsoftwareData.Service.BankPos.Meli;

namespace BankPosPay.Forms
{
    public partial class Frm_Main : Form
    {
       
        private readonly SynchronizationContext synchronizationContext;


        public Frm_Main()
        {
            InitializeComponent();
            synchronizationContext = SynchronizationContext.Current;
        }

        #region funtion
        public void ShowLoading(PictureBox pic, Label lb)
        {
            PictureBox.CheckForIllegalCrossThreadCalls = false;
            Label.CheckForIllegalCrossThreadCalls = false;
            lb.Visible = true;
            pic.Visible = true;
            lb.Refresh();
            pic.Refresh();

        }

        /// <summary>
        /// بستن لودینگ
        /// </summary>
        /// <param name="pic"></param>
        /// <param name="lb"></param>
        public void HideLoading(PictureBox pic, Label lb)
        {
            PictureBox.CheckForIllegalCrossThreadCalls = false;
            Label.CheckForIllegalCrossThreadCalls = false;
            lb.Visible = false;
            pic.Visible = false;
            lb.Refresh();
            pic.Refresh();

        }
        public int ToInt(string value)
        {
            if (string.IsNullOrWhiteSpace(value)) return 0;

            value = value.Replace(",", "");

            return int.TryParse(value, out var result) ? result : 0;
        }

      
        #endregion
      
       
        private void Frm_Main_Load(object sender, System.EventArgs e)
        {
            combo_Protocol.SelectedIndex = 0;
        }

        private void text_Amount_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!(char.IsDigit(e.KeyChar) || (char.IsControl(e.KeyChar))))
            {
                //-----عدم تاثیر گذاری در نوشتن کیبورد
                e.Handled = true;
            }
        }

        private async void btn_add_update_Click(object sender, EventArgs e)
        {
            if (string.IsNullOrWhiteSpace(text_Amount.Text))
            {
                errorProvider1.SetError(text_Amount, "لطفا مبلغ  را وارد کنید");

                return;
            }
            if (string.IsNullOrWhiteSpace(text_IP.Text))
            {
                errorProvider1.SetError(text_IP, "لطفا IP  را وارد کنید");

                return;
            }
            if (string.IsNullOrWhiteSpace(text_PortNumber.Text))
            {
                errorProvider1.SetError(text_PortNumber, "لطفا پورت  را وارد کنید");

                return;
            }
            if (string.IsNullOrWhiteSpace(text_TerminalId.Text))
            {
                errorProvider1.SetError(text_TerminalId, "لطفا شماره پایانه  را وارد کنید");

                return;
            }
            synchronizationContext.Post(new SendOrPostCallback(o =>
            {
                ShowLoading(pic_loding, lb_waite);


            }), null);
            try
            {

              
                text_TextOnBill.Clear();
                #region sepehrpay
                SadadPosTransaction sadadPosTransaction = new SadadPosTransaction()
                {
                    //-----خرید
                    MsgTypecount = 1,
                    Protocol = combo_Protocol.SelectedIndex,
                    TerminalID = text_TerminalId.Text,
                    Amount = text_Amount.Text,
                    PrintStr = text_customer.Text,
                    BillID = null,
                    PaymentID = null,
                    SpServiceID = null,
                    MultiAccTableVer = false,
                    POSSerialEnable = false,
                    POSSerialData = null,
                    //POSSerialData = "000071203187",
                    BankId = 0,
                    MultiAccEnable = false,
                    MultiAccData = null,
                    // MultiAccData = "21M01000000001000123456789012345678900M0200000000100009876543210987654321",
                    IPAddress = text_IP.Text,
                    IPPort = ToInt(text_PortNumber.Text),
                    PortNumber = text_PortNumber.Text,
                    CancelTimeout = ToInt(text_Time_Out.Text),

                };
                SadadPos sadadPos = new SadadPos();

                // اجرای تابع سنگین در Thread جدا
                var datasadad = await Task.Run(() => sadadPos.SendRequset(sadadPosTransaction));

                // بروزرسانی کنترل UI در Thread اصلی
                text_TextOnBill.Text = datasadad;

                #endregion


            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);

            }

            synchronizationContext.Post(new SendOrPostCallback(o =>
            {
                HideLoading(pic_loding, lb_waite);

            }), null);
        }
    }
}
